package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LambdaFunctionAssociation {

  def apply(
    lambdaFunction: software.amazon.awscdk.services.lambda.IVersion,
    eventType: software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType,
    includeBody: Option[Boolean] = None
  ): software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation =
    (new software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation.Builder)
      .lambdaFunction(lambdaFunction)
      .eventType(eventType)
      .includeBody(includeBody.map(Boolean.box).orNull)
      .build()
}
