package io.burkard.cdk.services.cloudformation

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHookVersionProps {

  def apply(
    typeName: String,
    schemaHandlerPackage: String,
    executionRoleArn: Option[String] = None,
    loggingConfig: Option[software.amazon.awscdk.services.cloudformation.CfnHookVersion.LoggingConfigProperty] = None
  ): software.amazon.awscdk.services.cloudformation.CfnHookVersionProps =
    (new software.amazon.awscdk.services.cloudformation.CfnHookVersionProps.Builder)
      .typeName(typeName)
      .schemaHandlerPackage(schemaHandlerPackage)
      .executionRoleArn(executionRoleArn.orNull)
      .loggingConfig(loggingConfig.orNull)
      .build()
}
