package io.burkard.cdk.services.cloudformation

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHookVersion {

  def apply(
    internalResourceId: String,
    typeName: String,
    schemaHandlerPackage: String,
    executionRoleArn: Option[String] = None,
    loggingConfig: Option[software.amazon.awscdk.services.cloudformation.CfnHookVersion.LoggingConfigProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.cloudformation.CfnHookVersion =
    software.amazon.awscdk.services.cloudformation.CfnHookVersion.Builder
      .create(stackCtx, internalResourceId)
      .typeName(typeName)
      .schemaHandlerPackage(schemaHandlerPackage)
      .executionRoleArn(executionRoleArn.orNull)
      .loggingConfig(loggingConfig.orNull)
      .build()
}
