package io.burkard.cdk.services.aps

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWorkspaceProps {

  def apply(
    alias: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    alertManagerDefinition: Option[String] = None
  ): software.amazon.awscdk.services.aps.CfnWorkspaceProps =
    (new software.amazon.awscdk.services.aps.CfnWorkspaceProps.Builder)
      .alias(alias.orNull)
      .tags(tags.map(_.asJava).orNull)
      .alertManagerDefinition(alertManagerDefinition.orNull)
      .build()
}
