package io.burkard.cdk.services.appstream

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnStackUserAssociationProps {

  def apply(
    userName: String,
    authenticationType: String,
    stackName: String,
    sendEmailNotification: Option[Boolean] = None
  ): software.amazon.awscdk.services.appstream.CfnStackUserAssociationProps =
    (new software.amazon.awscdk.services.appstream.CfnStackUserAssociationProps.Builder)
      .userName(userName)
      .authenticationType(authenticationType)
      .stackName(stackName)
      .sendEmailNotification(sendEmailNotification.map(Boolean.box).orNull)
      .build()
}
