package io.burkard.cdk.services.appstream

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEntitlementProps {

  def apply(
    name: String,
    attributes: List[_],
    appVisibility: String,
    stackName: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.appstream.CfnEntitlementProps =
    (new software.amazon.awscdk.services.appstream.CfnEntitlementProps.Builder)
      .name(name)
      .attributes(attributes.asJava)
      .appVisibility(appVisibility)
      .stackName(stackName)
      .description(description.orNull)
      .build()
}
