package io.burkard.cdk.services.appstream

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEntitlement {

  def apply(
    internalResourceId: String,
    name: String,
    attributes: List[_],
    appVisibility: String,
    stackName: String,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appstream.CfnEntitlement =
    software.amazon.awscdk.services.appstream.CfnEntitlement.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .attributes(attributes.asJava)
      .appVisibility(appVisibility)
      .stackName(stackName)
      .description(description.orNull)
      .build()
}
