package io.burkard.cdk.services.apprunner.cfnService

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SourceConfigurationProperty {

  def apply(
    autoDeploymentsEnabled: Option[Boolean] = None,
    codeRepository: Option[software.amazon.awscdk.services.apprunner.CfnService.CodeRepositoryProperty] = None,
    imageRepository: Option[software.amazon.awscdk.services.apprunner.CfnService.ImageRepositoryProperty] = None,
    authenticationConfiguration: Option[software.amazon.awscdk.services.apprunner.CfnService.AuthenticationConfigurationProperty] = None
  ): software.amazon.awscdk.services.apprunner.CfnService.SourceConfigurationProperty =
    (new software.amazon.awscdk.services.apprunner.CfnService.SourceConfigurationProperty.Builder)
      .autoDeploymentsEnabled(autoDeploymentsEnabled.map(Boolean.box).orNull)
      .codeRepository(codeRepository.orNull)
      .imageRepository(imageRepository.orNull)
      .authenticationConfiguration(authenticationConfiguration.orNull)
      .build()
}
