package io.burkard.cdk.services.applicationinsights.cfnApplication

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object WindowsEventProperty {

  def apply(
    eventName: String,
    eventLevels: List[String],
    logGroupName: String,
    patternSet: Option[String] = None
  ): software.amazon.awscdk.services.applicationinsights.CfnApplication.WindowsEventProperty =
    (new software.amazon.awscdk.services.applicationinsights.CfnApplication.WindowsEventProperty.Builder)
      .eventName(eventName)
      .eventLevels(eventLevels.asJava)
      .logGroupName(logGroupName)
      .patternSet(patternSet.orNull)
      .build()
}
