package io.burkard.cdk.services.apigateway.cfnMethod

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MethodResponseProperty {

  def apply(
    statusCode: String,
    responseParameters: Option[Map[String, _]] = None,
    responseModels: Option[Map[String, String]] = None
  ): software.amazon.awscdk.services.apigateway.CfnMethod.MethodResponseProperty =
    (new software.amazon.awscdk.services.apigateway.CfnMethod.MethodResponseProperty.Builder)
      .statusCode(statusCode)
      .responseParameters(responseParameters.map(_.asJava).orNull)
      .responseModels(responseModels.map(_.asJava).orNull)
      .build()
}
