package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ApiDefinitionConfig {

  def apply(
    inlineDefinition: Option[AnyRef] = None,
    s3Location: Option[software.amazon.awscdk.services.apigateway.ApiDefinitionS3Location] = None
  ): software.amazon.awscdk.services.apigateway.ApiDefinitionConfig =
    (new software.amazon.awscdk.services.apigateway.ApiDefinitionConfig.Builder)
      .inlineDefinition(inlineDefinition.orNull)
      .s3Location(s3Location.orNull)
      .build()
}
