package io.burkard.cdk.cloudassembly.schema

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SSMParameterContextQuery {

  def apply(
    region: String,
    account: String,
    parameterName: String,
    lookupRoleArn: Option[String] = None
  ): software.amazon.awscdk.cloudassembly.schema.SSMParameterContextQuery =
    (new software.amazon.awscdk.cloudassembly.schema.SSMParameterContextQuery.Builder)
      .region(region)
      .account(account)
      .parameterName(parameterName)
      .lookupRoleArn(lookupRoleArn.orNull)
      .build()
}
