package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHookVersionProps {

  def apply(
    typeName: String,
    schemaHandlerPackage: String,
    executionRoleArn: Option[String] = None,
    loggingConfig: Option[software.amazon.awscdk.CfnHookVersion.LoggingConfigProperty] = None
  ): software.amazon.awscdk.CfnHookVersionProps =
    (new software.amazon.awscdk.CfnHookVersionProps.Builder)
      .typeName(typeName)
      .schemaHandlerPackage(schemaHandlerPackage)
      .executionRoleArn(executionRoleArn.orNull)
      .loggingConfig(loggingConfig.orNull)
      .build()
}
