package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object App {

  def apply(
    treeMetadata: Option[Boolean] = None,
    context: Option[Map[String, _]] = None,
    outdir: Option[String] = None,
    autoSynth: Option[Boolean] = None,
    analyticsReporting: Option[Boolean] = None,
    stackTraces: Option[Boolean] = None
  ): software.amazon.awscdk.App =
    software.amazon.awscdk.App.Builder
      .create()
      .treeMetadata(treeMetadata.map(Boolean.box).orNull)
      .context(context.map(_.asJava).orNull)
      .outdir(outdir.orNull)
      .autoSynth(autoSynth.map(Boolean.box).orNull)
      .analyticsReporting(analyticsReporting.map(Boolean.box).orNull)
      .stackTraces(stackTraces.map(Boolean.box).orNull)
      .build()
}
