package io.burkard.cdk.services.stepfunctions.tasks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AlgorithmSpecification {

  def apply(
    metricDefinitions: Option[List[_ <: software.amazon.awscdk.services.stepfunctions.tasks.MetricDefinition]] = None,
    trainingImage: Option[software.amazon.awscdk.services.stepfunctions.tasks.DockerImage] = None,
    trainingInputMode: Option[software.amazon.awscdk.services.stepfunctions.tasks.InputMode] = None,
    algorithmName: Option[String] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification =
    (new software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification.Builder)
      .metricDefinitions(metricDefinitions.map(_.asJava).orNull)
      .trainingImage(trainingImage.orNull)
      .trainingInputMode(trainingInputMode.orNull)
      .algorithmName(algorithmName.orNull)
      .build()
}
