package io.burkard.cdk.services.sagemaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnNotebookInstanceLifecycleConfig {

  def apply(
    internalResourceId: String,
    onStart: Option[List[_]] = None,
    onCreate: Option[List[_]] = None,
    notebookInstanceLifecycleConfigName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.sagemaker.CfnNotebookInstanceLifecycleConfig =
    software.amazon.awscdk.services.sagemaker.CfnNotebookInstanceLifecycleConfig.Builder
      .create(stackCtx, internalResourceId)
      .onStart(onStart.map(_.asJava).orNull)
      .onCreate(onCreate.map(_.asJava).orNull)
      .notebookInstanceLifecycleConfigName(notebookInstanceLifecycleConfigName.orNull)
      .build()
}
