package io.burkard.cdk.services.s3.cfnBucket

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RuleProperty {

  def apply(
    status: String,
    tagFilters: Option[List[_]] = None,
    expirationDate: Option[java.time.Instant] = None,
    noncurrentVersionExpiration: Option[software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionExpirationProperty] = None,
    noncurrentVersionTransitions: Option[List[_]] = None,
    prefix: Option[String] = None,
    expirationInDays: Option[Number] = None,
    objectSizeGreaterThan: Option[Number] = None,
    expiredObjectDeleteMarker: Option[Boolean] = None,
    abortIncompleteMultipartUpload: Option[software.amazon.awscdk.services.s3.CfnBucket.AbortIncompleteMultipartUploadProperty] = None,
    transitions: Option[List[_]] = None,
    id: Option[String] = None,
    noncurrentVersionExpirationInDays: Option[Number] = None,
    transition: Option[software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty] = None,
    noncurrentVersionTransition: Option[software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty] = None,
    objectSizeLessThan: Option[Number] = None
  ): software.amazon.awscdk.services.s3.CfnBucket.RuleProperty =
    (new software.amazon.awscdk.services.s3.CfnBucket.RuleProperty.Builder)
      .status(status)
      .tagFilters(tagFilters.map(_.asJava).orNull)
      .expirationDate(expirationDate.orNull)
      .noncurrentVersionExpiration(noncurrentVersionExpiration.orNull)
      .noncurrentVersionTransitions(noncurrentVersionTransitions.map(_.asJava).orNull)
      .prefix(prefix.orNull)
      .expirationInDays(expirationInDays.orNull)
      .objectSizeGreaterThan(objectSizeGreaterThan.orNull)
      .expiredObjectDeleteMarker(expiredObjectDeleteMarker.map(Boolean.box).orNull)
      .abortIncompleteMultipartUpload(abortIncompleteMultipartUpload.orNull)
      .transitions(transitions.map(_.asJava).orNull)
      .id(id.orNull)
      .noncurrentVersionExpirationInDays(noncurrentVersionExpirationInDays.orNull)
      .transition(transition.orNull)
      .noncurrentVersionTransition(noncurrentVersionTransition.orNull)
      .objectSizeLessThan(objectSizeLessThan.orNull)
      .build()
}
