package io.burkard.cdk.services.rum.cfnAppMonitor

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AppMonitorConfigurationProperty {

  def apply(
    sessionSampleRate: Option[Number] = None,
    excludedPages: Option[List[String]] = None,
    includedPages: Option[List[String]] = None,
    guestRoleArn: Option[String] = None,
    enableXRay: Option[Boolean] = None,
    identityPoolId: Option[String] = None,
    telemetries: Option[List[String]] = None,
    allowCookies: Option[Boolean] = None,
    favoritePages: Option[List[String]] = None
  ): software.amazon.awscdk.services.rum.CfnAppMonitor.AppMonitorConfigurationProperty =
    (new software.amazon.awscdk.services.rum.CfnAppMonitor.AppMonitorConfigurationProperty.Builder)
      .sessionSampleRate(sessionSampleRate.orNull)
      .excludedPages(excludedPages.map(_.asJava).orNull)
      .includedPages(includedPages.map(_.asJava).orNull)
      .guestRoleArn(guestRoleArn.orNull)
      .enableXRay(enableXRay.map(Boolean.box).orNull)
      .identityPoolId(identityPoolId.orNull)
      .telemetries(telemetries.map(_.asJava).orNull)
      .allowCookies(allowCookies.map(Boolean.box).orNull)
      .favoritePages(favoritePages.map(_.asJava).orNull)
      .build()
}
