package io.burkard.cdk.services.logs.cfnMetricFilter

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MetricTransformationProperty {

  def apply(
    metricNamespace: String,
    metricValue: String,
    metricName: String,
    defaultValue: Option[Number] = None
  ): software.amazon.awscdk.services.logs.CfnMetricFilter.MetricTransformationProperty =
    (new software.amazon.awscdk.services.logs.CfnMetricFilter.MetricTransformationProperty.Builder)
      .metricNamespace(metricNamespace)
      .metricValue(metricValue)
      .metricName(metricName)
      .defaultValue(defaultValue.orNull)
      .build()
}
