package io.burkard.cdk.services.logs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LogGroupProps {

  def apply(
    retention: Option[software.amazon.awscdk.services.logs.RetentionDays] = None,
    logGroupName: Option[String] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    encryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None
  ): software.amazon.awscdk.services.logs.LogGroupProps =
    (new software.amazon.awscdk.services.logs.LogGroupProps.Builder)
      .retention(retention.orNull)
      .logGroupName(logGroupName.orNull)
      .removalPolicy(removalPolicy.orNull)
      .encryptionKey(encryptionKey.orNull)
      .build()
}
