package io.burkard.cdk.services.lightsail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnContainerProps {

  def apply(
    scale: Number,
    serviceName: String,
    power: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    containerServiceDeployment: Option[software.amazon.awscdk.services.lightsail.CfnContainer.ContainerServiceDeploymentProperty] = None,
    publicDomainNames: Option[List[_]] = None,
    isDisabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.lightsail.CfnContainerProps =
    (new software.amazon.awscdk.services.lightsail.CfnContainerProps.Builder)
      .scale(scale)
      .serviceName(serviceName)
      .power(power)
      .tags(tags.map(_.asJava).orNull)
      .containerServiceDeployment(containerServiceDeployment.orNull)
      .publicDomainNames(publicDomainNames.map(_.asJava).orNull)
      .isDisabled(isDisabled.map(Boolean.box).orNull)
      .build()
}
