package io.burkard.cdk.services.lex.cfnBot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SlotValueElicitationSettingProperty {

  def apply(
    slotConstraint: String,
    sampleUtterances: Option[List[_]] = None,
    promptSpecification: Option[software.amazon.awscdk.services.lex.CfnBot.PromptSpecificationProperty] = None,
    defaultValueSpecification: Option[software.amazon.awscdk.services.lex.CfnBot.SlotDefaultValueSpecificationProperty] = None,
    waitAndContinueSpecification: Option[software.amazon.awscdk.services.lex.CfnBot.WaitAndContinueSpecificationProperty] = None
  ): software.amazon.awscdk.services.lex.CfnBot.SlotValueElicitationSettingProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.SlotValueElicitationSettingProperty.Builder)
      .slotConstraint(slotConstraint)
      .sampleUtterances(sampleUtterances.map(_.asJava).orNull)
      .promptSpecification(promptSpecification.orNull)
      .defaultValueSpecification(defaultValueSpecification.orNull)
      .waitAndContinueSpecification(waitAndContinueSpecification.orNull)
      .build()
}
