package io.burkard.cdk.services.inspectorv2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFilterProps {

  def apply(
    name: String,
    filterCriteria: software.amazon.awscdk.services.inspectorv2.CfnFilter.FilterCriteriaProperty,
    filterAction: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.inspectorv2.CfnFilterProps =
    (new software.amazon.awscdk.services.inspectorv2.CfnFilterProps.Builder)
      .name(name)
      .filterCriteria(filterCriteria)
      .filterAction(filterAction)
      .description(description.orNull)
      .build()
}
