package io.burkard.cdk.services.frauddetector.cfnDetector

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EventTypeProperty {

  def apply(
    eventVariables: Option[List[_]] = None,
    arn: Option[String] = None,
    name: Option[String] = None,
    lastUpdatedTime: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    inline: Option[Boolean] = None,
    createdTime: Option[String] = None,
    labels: Option[List[_]] = None,
    entityTypes: Option[List[_]] = None
  ): software.amazon.awscdk.services.frauddetector.CfnDetector.EventTypeProperty =
    (new software.amazon.awscdk.services.frauddetector.CfnDetector.EventTypeProperty.Builder)
      .eventVariables(eventVariables.map(_.asJava).orNull)
      .arn(arn.orNull)
      .name(name.orNull)
      .lastUpdatedTime(lastUpdatedTime.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .inline(inline.map(Boolean.box).orNull)
      .createdTime(createdTime.orNull)
      .labels(labels.map(_.asJava).orNull)
      .entityTypes(entityTypes.map(_.asJava).orNull)
      .build()
}
