package io.burkard.cdk.services.ecs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object JournaldLogDriverProps {

  def apply(
    env: Option[List[String]] = None,
    tag: Option[String] = None,
    labels: Option[List[String]] = None,
    envRegex: Option[String] = None
  ): software.amazon.awscdk.services.ecs.JournaldLogDriverProps =
    (new software.amazon.awscdk.services.ecs.JournaldLogDriverProps.Builder)
      .env(env.map(_.asJava).orNull)
      .tag(tag.orNull)
      .labels(labels.map(_.asJava).orNull)
      .envRegex(envRegex.orNull)
      .build()
}
