package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AddAutoScalingGroupCapacityOptions {

  def apply(
    machineImageType: Option[software.amazon.awscdk.services.ecs.MachineImageType] = None,
    canContainersAccessInstanceRole: Option[Boolean] = None,
    spotInstanceDraining: Option[Boolean] = None,
    topicEncryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None
  ): software.amazon.awscdk.services.ecs.AddAutoScalingGroupCapacityOptions =
    (new software.amazon.awscdk.services.ecs.AddAutoScalingGroupCapacityOptions.Builder)
      .machineImageType(machineImageType.orNull)
      .canContainersAccessInstanceRole(canContainersAccessInstanceRole.map(Boolean.box).orNull)
      .spotInstanceDraining(spotInstanceDraining.map(Boolean.box).orNull)
      .topicEncryptionKey(topicEncryptionKey.orNull)
      .build()
}
