package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SelectedSubnets {

  def apply(
    subnetIds: List[String],
    subnets: List[_ <: software.amazon.awscdk.services.ec2.ISubnet],
    hasPublic: Boolean,
    internetConnectivityEstablished: software.constructs.IDependable,
    availabilityZones: List[String],
    isPendingLookup: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.SelectedSubnets =
    (new software.amazon.awscdk.services.ec2.SelectedSubnets.Builder)
      .subnetIds(subnetIds.asJava)
      .subnets(subnets.asJava)
      .hasPublic(hasPublic)
      .internetConnectivityEstablished(internetConnectivityEstablished)
      .availabilityZones(availabilityZones.asJava)
      .isPendingLookup(isPendingLookup.map(Boolean.box).orNull)
      .build()
}
