package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSubnetProps {

  def apply(
    vpcId: String,
    cidrBlock: String,
    assignIpv6AddressOnCreation: Option[Boolean] = None,
    availabilityZoneId: Option[String] = None,
    privateDnsNameOptionsOnLaunch: Option[software.amazon.awscdk.services.ec2.CfnSubnet.PrivateDnsNameOptionsOnLaunchProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    enableDns64: Option[Boolean] = None,
    availabilityZone: Option[String] = None,
    ipv6Native: Option[Boolean] = None,
    outpostArn: Option[String] = None,
    ipv6CidrBlock: Option[String] = None,
    mapPublicIpOnLaunch: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.CfnSubnetProps =
    (new software.amazon.awscdk.services.ec2.CfnSubnetProps.Builder)
      .vpcId(vpcId)
      .cidrBlock(cidrBlock)
      .assignIpv6AddressOnCreation(assignIpv6AddressOnCreation.map(Boolean.box).orNull)
      .availabilityZoneId(availabilityZoneId.orNull)
      .privateDnsNameOptionsOnLaunch(privateDnsNameOptionsOnLaunch.orNull)
      .tags(tags.map(_.asJava).orNull)
      .enableDns64(enableDns64.map(Boolean.box).orNull)
      .availabilityZone(availabilityZone.orNull)
      .ipv6Native(ipv6Native.map(Boolean.box).orNull)
      .outpostArn(outpostArn.orNull)
      .ipv6CidrBlock(ipv6CidrBlock.orNull)
      .mapPublicIpOnLaunch(mapPublicIpOnLaunch.map(Boolean.box).orNull)
      .build()
}
