package io.burkard.cdk.services.appintegrations

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDataIntegrationProps {

  def apply(
    name: String,
    kmsKey: String,
    sourceUri: String,
    scheduleConfig: software.amazon.awscdk.services.appintegrations.CfnDataIntegration.ScheduleConfigProperty,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.appintegrations.CfnDataIntegrationProps =
    (new software.amazon.awscdk.services.appintegrations.CfnDataIntegrationProps.Builder)
      .name(name)
      .kmsKey(kmsKey)
      .sourceUri(sourceUri)
      .scheduleConfig(scheduleConfig)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
