package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RequestValidatorProps {

  def apply(
    restApi: software.amazon.awscdk.services.apigateway.IRestApi,
    validateRequestParameters: Option[Boolean] = None,
    validateRequestBody: Option[Boolean] = None,
    requestValidatorName: Option[String] = None
  ): software.amazon.awscdk.services.apigateway.RequestValidatorProps =
    (new software.amazon.awscdk.services.apigateway.RequestValidatorProps.Builder)
      .restApi(restApi)
      .validateRequestParameters(validateRequestParameters.map(Boolean.box).orNull)
      .validateRequestBody(validateRequestBody.map(Boolean.box).orNull)
      .requestValidatorName(requestValidatorName.orNull)
      .build()
}
