package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RequestValidator {

  def apply(
    internalResourceId: String,
    restApi: software.amazon.awscdk.services.apigateway.IRestApi,
    validateRequestParameters: Option[Boolean] = None,
    validateRequestBody: Option[Boolean] = None,
    requestValidatorName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.apigateway.RequestValidator =
    software.amazon.awscdk.services.apigateway.RequestValidator.Builder
      .create(stackCtx, internalResourceId)
      .restApi(restApi)
      .validateRequestParameters(validateRequestParameters.map(Boolean.box).orNull)
      .validateRequestBody(validateRequestBody.map(Boolean.box).orNull)
      .requestValidatorName(requestValidatorName.orNull)
      .build()
}
