package io.burkard.cdk.services.amplifyuibuilder

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnComponentProps {

  def apply(
    name: String,
    overrides: Map[String, _],
    componentType: String,
    properties: Map[String, _],
    bindingProperties: Map[String, _],
    variants: List[_],
    children: Option[List[_]] = None,
    collectionProperties: Option[Map[String, _]] = None,
    tags: Option[Map[String, String]] = None,
    events: Option[Map[String, _]] = None,
    sourceId: Option[String] = None
  ): software.amazon.awscdk.services.amplifyuibuilder.CfnComponentProps =
    (new software.amazon.awscdk.services.amplifyuibuilder.CfnComponentProps.Builder)
      .name(name)
      .overrides(overrides.asJava)
      .componentType(componentType)
      .properties(properties.asJava)
      .bindingProperties(bindingProperties.asJava)
      .variants(variants.asJava)
      .children(children.map(_.asJava).orNull)
      .collectionProperties(collectionProperties.map(_.asJava).orNull)
      .tags(tags.map(_.asJava).orNull)
      .events(events.map(_.asJava).orNull)
      .sourceId(sourceId.orNull)
      .build()
}
