package io.burkard.cdk.services.sagemaker.cfnEndpointConfig

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ProductionVariantProperty {

  def apply(
    variantName: String,
    modelName: String,
    initialVariantWeight: Number,
    instanceType: Option[String] = None,
    acceleratorType: Option[String] = None,
    serverlessConfig: Option[software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ServerlessConfigProperty] = None,
    initialInstanceCount: Option[Number] = None
  ): software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ProductionVariantProperty =
    (new software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ProductionVariantProperty.Builder)
      .variantName(variantName)
      .modelName(modelName)
      .initialVariantWeight(initialVariantWeight)
      .instanceType(instanceType.orNull)
      .acceleratorType(acceleratorType.orNull)
      .serverlessConfig(serverlessConfig.orNull)
      .initialInstanceCount(initialInstanceCount.orNull)
      .build()
}
