package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnADMChannelProps {

  def apply(
    clientId: String,
    applicationId: String,
    clientSecret: String,
    enabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.pinpoint.CfnADMChannelProps =
    (new software.amazon.awscdk.services.pinpoint.CfnADMChannelProps.Builder)
      .clientId(clientId)
      .applicationId(applicationId)
      .clientSecret(clientSecret)
      .enabled(enabled.map(Boolean.box).orNull)
      .build()
}
