package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnADMChannel {

  def apply(
    internalResourceId: String,
    clientId: String,
    applicationId: String,
    clientSecret: String,
    enabled: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.pinpoint.CfnADMChannel =
    software.amazon.awscdk.services.pinpoint.CfnADMChannel.Builder
      .create(stackCtx, internalResourceId)
      .clientId(clientId)
      .applicationId(applicationId)
      .clientSecret(clientSecret)
      .enabled(enabled.map(Boolean.box).orNull)
      .build()
}
