package io.burkard.cdk.services.kinesisanalyticsv2.cfnApplication

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ZeppelinApplicationConfigurationProperty {

  def apply(
    monitoringConfiguration: Option[software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ZeppelinMonitoringConfigurationProperty] = None,
    catalogConfiguration: Option[software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.CatalogConfigurationProperty] = None,
    customArtifactsConfiguration: Option[List[_]] = None,
    deployAsApplicationConfiguration: Option[software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.DeployAsApplicationConfigurationProperty] = None
  ): software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ZeppelinApplicationConfigurationProperty =
    (new software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ZeppelinApplicationConfigurationProperty.Builder)
      .monitoringConfiguration(monitoringConfiguration.orNull)
      .catalogConfiguration(catalogConfiguration.orNull)
      .customArtifactsConfiguration(customArtifactsConfiguration.map(_.asJava).orNull)
      .deployAsApplicationConfiguration(deployAsApplicationConfiguration.orNull)
      .build()
}
