package io.burkard.cdk.services.iot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnProvisioningTemplateProps {

  def apply(
    provisioningRoleArn: String,
    templateBody: String,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    enabled: Option[Boolean] = None,
    templateName: Option[String] = None,
    preProvisioningHook: Option[software.amazon.awscdk.services.iot.CfnProvisioningTemplate.ProvisioningHookProperty] = None
  ): software.amazon.awscdk.services.iot.CfnProvisioningTemplateProps =
    (new software.amazon.awscdk.services.iot.CfnProvisioningTemplateProps.Builder)
      .provisioningRoleArn(provisioningRoleArn)
      .templateBody(templateBody)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .templateName(templateName.orNull)
      .preProvisioningHook(preProvisioningHook.orNull)
      .build()
}
