package io.burkard.cdk.services.emr.cfnCluster

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VolumeSpecificationProperty {

  def apply(
    volumeType: String,
    sizeInGb: Number,
    iops: Option[Number] = None
  ): software.amazon.awscdk.services.emr.CfnCluster.VolumeSpecificationProperty =
    (new software.amazon.awscdk.services.emr.CfnCluster.VolumeSpecificationProperty.Builder)
      .volumeType(volumeType)
      .sizeInGb(sizeInGb)
      .iops(iops.orNull)
      .build()
}
