package io.burkard.cdk.services.elasticsearch.cfnDomain

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EBSOptionsProperty {

  def apply(
    volumeSize: Option[Number] = None,
    volumeType: Option[String] = None,
    iops: Option[Number] = None,
    ebsEnabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.elasticsearch.CfnDomain.EBSOptionsProperty =
    (new software.amazon.awscdk.services.elasticsearch.CfnDomain.EBSOptionsProperty.Builder)
      .volumeSize(volumeSize.orNull)
      .volumeType(volumeType.orNull)
      .iops(iops.orNull)
      .ebsEnabled(ebsEnabled.map(Boolean.box).orNull)
      .build()
}
