package io.burkard.cdk.services.elasticloadbalancingv2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HealthCheck {

  def apply(
    unhealthyThresholdCount: Option[Number] = None,
    path: Option[String] = None,
    healthyGrpcCodes: Option[String] = None,
    enabled: Option[Boolean] = None,
    healthyThresholdCount: Option[Number] = None,
    interval: Option[software.amazon.awscdk.Duration] = None,
    port: Option[String] = None,
    healthyHttpCodes: Option[String] = None,
    timeout: Option[software.amazon.awscdk.Duration] = None,
    protocol: Option[software.amazon.awscdk.services.elasticloadbalancingv2.Protocol] = None
  ): software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck =
    (new software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.Builder)
      .unhealthyThresholdCount(unhealthyThresholdCount.orNull)
      .path(path.orNull)
      .healthyGrpcCodes(healthyGrpcCodes.orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .healthyThresholdCount(healthyThresholdCount.orNull)
      .interval(interval.orNull)
      .port(port.orNull)
      .healthyHttpCodes(healthyHttpCodes.orNull)
      .timeout(timeout.orNull)
      .protocol(protocol.orNull)
      .build()
}
