package io.burkard.cdk.services.eks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object KubernetesPatchProps {

  def apply(
    applyPatch: Map[String, _],
    resourceName: String,
    cluster: software.amazon.awscdk.services.eks.ICluster,
    restorePatch: Map[String, _],
    patchType: Option[software.amazon.awscdk.services.eks.PatchType] = None,
    resourceNamespace: Option[String] = None
  ): software.amazon.awscdk.services.eks.KubernetesPatchProps =
    (new software.amazon.awscdk.services.eks.KubernetesPatchProps.Builder)
      .applyPatch(applyPatch.asJava)
      .resourceName(resourceName)
      .cluster(cluster)
      .restorePatch(restorePatch.asJava)
      .patchType(patchType.orNull)
      .resourceNamespace(resourceNamespace.orNull)
      .build()
}
