package io.burkard.cdk.services.dms

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEventSubscription {

  def apply(
    internalResourceId: String,
    snsTopicArn: String,
    sourceType: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    enabled: Option[Boolean] = None,
    sourceIds: Option[List[String]] = None,
    subscriptionName: Option[String] = None,
    eventCategories: Option[List[String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.dms.CfnEventSubscription =
    software.amazon.awscdk.services.dms.CfnEventSubscription.Builder
      .create(stackCtx, internalResourceId)
      .snsTopicArn(snsTopicArn)
      .sourceType(sourceType.orNull)
      .tags(tags.map(_.asJava).orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .sourceIds(sourceIds.map(_.asJava).orNull)
      .subscriptionName(subscriptionName.orNull)
      .eventCategories(eventCategories.map(_.asJava).orNull)
      .build()
}
