package io.burkard.cdk.services.databrew.cfnDataset

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InputProperty {

  def apply(
    s3InputDefinition: Option[software.amazon.awscdk.services.databrew.CfnDataset.S3LocationProperty] = None,
    databaseInputDefinition: Option[software.amazon.awscdk.services.databrew.CfnDataset.DatabaseInputDefinitionProperty] = None,
    dataCatalogInputDefinition: Option[software.amazon.awscdk.services.databrew.CfnDataset.DataCatalogInputDefinitionProperty] = None,
    metadata: Option[software.amazon.awscdk.services.databrew.CfnDataset.MetadataProperty] = None
  ): software.amazon.awscdk.services.databrew.CfnDataset.InputProperty =
    (new software.amazon.awscdk.services.databrew.CfnDataset.InputProperty.Builder)
      .s3InputDefinition(s3InputDefinition.orNull)
      .databaseInputDefinition(databaseInputDefinition.orNull)
      .dataCatalogInputDefinition(dataCatalogInputDefinition.orNull)
      .metadata(metadata.orNull)
      .build()
}
