package io.burkard.cdk.services.codepipeline.actions

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AlexaSkillDeployActionProps {

  def apply(
    clientId: String,
    skillId: String,
    clientSecret: software.amazon.awscdk.SecretValue,
    input: software.amazon.awscdk.services.codepipeline.Artifact,
    refreshToken: software.amazon.awscdk.SecretValue,
    parameterOverridesArtifact: Option[software.amazon.awscdk.services.codepipeline.Artifact] = None,
    variablesNamespace: Option[String] = None,
    runOrder: Option[Number] = None,
    actionName: Option[String] = None
  ): software.amazon.awscdk.services.codepipeline.actions.AlexaSkillDeployActionProps =
    (new software.amazon.awscdk.services.codepipeline.actions.AlexaSkillDeployActionProps.Builder)
      .clientId(clientId)
      .skillId(skillId)
      .clientSecret(clientSecret)
      .input(input)
      .refreshToken(refreshToken)
      .parameterOverridesArtifact(parameterOverridesArtifact.orNull)
      .variablesNamespace(variablesNamespace.orNull)
      .runOrder(runOrder.orNull)
      .actionName(actionName.orNull)
      .build()
}
