package io.burkard.cdk.services.cloudfront

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ViewerCertificateOptions {

  def apply(
    aliases: Option[List[String]] = None,
    securityPolicy: Option[software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol] = None,
    sslMethod: Option[software.amazon.awscdk.services.cloudfront.SSLMethod] = None
  ): software.amazon.awscdk.services.cloudfront.ViewerCertificateOptions =
    (new software.amazon.awscdk.services.cloudfront.ViewerCertificateOptions.Builder)
      .aliases(aliases.map(_.asJava).orNull)
      .securityPolicy(securityPolicy.orNull)
      .sslMethod(sslMethod.orNull)
      .build()
}
