package io.burkard.cdk.services.appstream.cfnAppBlock

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ScriptDetailsProperty {

  def apply(
    scriptS3Location: software.amazon.awscdk.services.appstream.CfnAppBlock.S3LocationProperty,
    executablePath: String,
    timeoutInSeconds: Number,
    executableParameters: Option[String] = None
  ): software.amazon.awscdk.services.appstream.CfnAppBlock.ScriptDetailsProperty =
    (new software.amazon.awscdk.services.appstream.CfnAppBlock.ScriptDetailsProperty.Builder)
      .scriptS3Location(scriptS3Location)
      .executablePath(executablePath)
      .timeoutInSeconds(timeoutInSeconds)
      .executableParameters(executableParameters.orNull)
      .build()
}
