package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HttpGatewayRoutePathMatchConfig {

  def apply(
    prefixPathMatch: Option[String] = None,
    wholePathMatch: Option[software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpPathMatchProperty] = None,
    wholePathRewrite: Option[software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty] = None,
    prefixPathRewrite: Option[software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty] = None
  ): software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatchConfig =
    (new software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatchConfig.Builder)
      .prefixPathMatch(prefixPathMatch.orNull)
      .wholePathMatch(wholePathMatch.orNull)
      .wholePathRewrite(wholePathRewrite.orNull)
      .prefixPathRewrite(prefixPathRewrite.orNull)
      .build()
}
