package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MethodDeploymentOptions {

  def apply(
    throttlingBurstLimit: Option[Number] = None,
    dataTraceEnabled: Option[Boolean] = None,
    loggingLevel: Option[software.amazon.awscdk.services.apigateway.MethodLoggingLevel] = None,
    throttlingRateLimit: Option[Number] = None,
    cacheDataEncrypted: Option[Boolean] = None,
    cacheTtl: Option[software.amazon.awscdk.Duration] = None,
    cachingEnabled: Option[Boolean] = None,
    metricsEnabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.apigateway.MethodDeploymentOptions =
    (new software.amazon.awscdk.services.apigateway.MethodDeploymentOptions.Builder)
      .throttlingBurstLimit(throttlingBurstLimit.orNull)
      .dataTraceEnabled(dataTraceEnabled.map(Boolean.box).orNull)
      .loggingLevel(loggingLevel.orNull)
      .throttlingRateLimit(throttlingRateLimit.orNull)
      .cacheDataEncrypted(cacheDataEncrypted.map(Boolean.box).orNull)
      .cacheTtl(cacheTtl.orNull)
      .cachingEnabled(cachingEnabled.map(Boolean.box).orNull)
      .metricsEnabled(metricsEnabled.map(Boolean.box).orNull)
      .build()
}
