package io.burkard.cdk.services.amplifyuibuilder

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTheme {

  def apply(
    internalResourceId: String,
    name: String,
    values: List[_],
    tags: Option[Map[String, String]] = None,
    overrides: Option[List[_]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.amplifyuibuilder.CfnTheme =
    software.amazon.awscdk.services.amplifyuibuilder.CfnTheme.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .values(values.asJava)
      .tags(tags.map(_.asJava).orNull)
      .overrides(overrides.map(_.asJava).orNull)
      .build()
}
