package io.burkard.cdk.services.stepfunctions.tasks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ResourceConfig {

  def apply(
    instanceCount: Number,
    instanceType: software.amazon.awscdk.services.ec2.InstanceType,
    volumeSize: software.amazon.awscdk.Size,
    volumeEncryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig =
    (new software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig.Builder)
      .instanceCount(instanceCount)
      .instanceType(instanceType)
      .volumeSize(volumeSize)
      .volumeEncryptionKey(volumeEncryptionKey.orNull)
      .build()
}
